/***************************************************************/
//
//
//		DirectX	[mouse.cpp]
//
//										Author	kazuki tanaka
//										Date	2016 07/08
/*---------------------------------------------------------------
Update : 2016/07/08
			mouse.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/
#include "input.h"
#include "mouse.h"
#include "main.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/
#define	NUM_KEY_MAX			( 8 )	// L[̍ő吔
#define	LIMIT_COUNT_REPEAT	( 5 )	// s[gJEg~b^[

/*---------------------------------------------------------------
	O[oϐ
---------------------------------------------------------------*/

LPDIRECTINPUTDEVICE8	g_pDevMouse = NULL;					// ̓foCX(}EX)ւ̃|C^
//BYTE					g_dims[NUM_KEY_MAX];				// }EX̓͏񃏁[N
BYTE					g_dimsTrigger[NUM_KEY_MAX];			// }EX̃gK[񃏁[N
BYTE					g_dimsRelease[NUM_KEY_MAX];			// }EX̃[X񃏁[N
BYTE					g_dimsRepeat[NUM_KEY_MAX];			// }EX̃s[g񃏁[N
int						g_dimsRepeatCnt[NUM_KEY_MAX];		// }EX̃s[gJE^
float                   mouseWheel = 0;
D3DXVECTOR2             mouseMove;

DIMOUSESTATE2			g_dims;								// }EX̏

// }EX̏
HRESULT InitMouse(HINSTANCE hInstance, HWND hWnd)
{
	// ͏̏
	if(FAILED(InitInput(hInstance, hWnd)))
	{
		MessageBox(hWnd, "DirectInputIuWFNg˂I", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// foCX̍쐬
	LPDIRECTINPUT8 g_pInput = GetInputDevice( );
	if(FAILED(g_pInput->CreateDevice(GUID_SysMouse, &g_pDevMouse, NULL)))
	{
		MessageBox(hWnd, "}EX˂I", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// f[^tH[}bgݒ
	if(FAILED(g_pDevMouse->SetDataFormat(&c_dfDIMouse2)))
	{
		MessageBox(hWnd, "}EX̃f[^tH[}bgݒł܂łB", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// [hݒitHAOEhr[hj
	if(FAILED(g_pDevMouse->SetCooperativeLevel(hWnd, (DISCL_FOREGROUND | DISCL_NONEXCLUSIVE))))
	{
		MessageBox(hWnd, "}EX̋[hݒł܂łB", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// }EXւ̃ANZXl(͐Jn)
	if( FAILED( g_pDevMouse ->Poll() ) )
	{
		g_pDevMouse->Acquire();
	}

	return S_OK;
}

// }EX̏I
void UninitMouse(void)
{
	if(g_pDevMouse != NULL)
	{// ̓foCX(}EX)̊J
		// }EXւ̃ANZXJ(͐I)
		g_pDevMouse->Unacquire();

		g_pDevMouse->Release();
		g_pDevMouse = NULL;
	}

	// ͏̏I
	UninitInput();
}

// }EX̍XV
void UpdateMouse(void)
{

	//BYTE aKeyState[NUM_KEY_MAX];

	DIMOUSESTATE2 dims;
	LPPOINT lpPoint = NULL;


	// foCXf[^擾
	//if(SUCCEEDED(g_pDevMouse->GetDeviceState(sizeof(aKeyState), aKeyState)))
	if(SUCCEEDED(g_pDevMouse->GetDeviceState(sizeof(DIMOUSESTATE2), &dims )))
	{

		mouseWheel = dims.lZ/40 * 1.0f + mouseWheel;
		g_dims.lZ  = dims.lZ/40 * 1.0f;
 
		for(int nCnKey = 0; nCnKey < NUM_KEY_MAX; nCnKey++)
		{
			
			//L[gK[[X̍쐬
			g_dimsTrigger[nCnKey]=(g_dims.rgbButtons[nCnKey] ^ dims.rgbButtons[nCnKey]) & dims.rgbButtons[nCnKey];

			g_dimsRelease[nCnKey]=(g_dims.rgbButtons[nCnKey] ^ dims.rgbButtons[nCnKey]) & g_dims.rgbButtons[nCnKey];

			//L[s[g̐
			if( dims.rgbButtons[nCnKey] & 0x80 ){			//sNꍇ, if( dims.rgbButtons[nCnKey] & 0x80 )
				if(g_dimsRepeatCnt[nCnKey] < LIMIT_COUNT_REPEAT){
					g_dimsRepeatCnt[nCnKey]++;
					if( g_dimsRepeatCnt[nCnKey]==1){
					//if( g_dimsRepeatCnt[nCnKey]==1 || g_dimsRepeatCnt[nCnKey]>=LIMIT_COUNT_REPEAT ){

						g_dimsRepeat[nCnKey]=dims.rgbButtons[nCnKey];
					
					}
					else{
						
						g_dimsRepeat[nCnKey] = 0 ;

					}
				}
			}
			else{
			
				g_dimsRepeat[nCnKey]=0;
				g_dimsRepeatCnt[nCnKey]=0;

			}

			// L[vXۑ
			g_dims.rgbButtons[nCnKey] = dims.rgbButtons[nCnKey];

		}

		// L[vXۑ
		//g_dims = dims;

		HWND hWnd;
		POINT pos;

		// ݂̃EBhẼ|WVł΂ǂł悢
		pos.x = SCREEN_WIDTH;
		pos.y = SCREEN_HEIGHT;

		hWnd = WindowFromPoint( pos );

		// }EX̍W擾
		GetCursorPos( &pos );

		// XN[WNCAgW
		ScreenToClient( hWnd, &pos );

		dims.lX = pos.x;
		dims.lY = pos.y;
		
		mouseMove.x = g_dims.lX - dims.lX;
		mouseMove.y = g_dims.lY - dims.lY;

		g_dims.lX = dims.lX;
		g_dims.lY = dims.lY;

	}
	else{
		// }EXւ̃ANZX擾
		g_pDevMouse->Acquire();
	}
}

// }EX̃L[l̎擾
DIMOUSESTATE2 GetMouse( void )
{
	return g_dims;
}

// }EX̃vXԂ擾
bool GetMousePress(int nKey)
{
	//return (g_dims[nKey] & 0x80) ? true: false;
	return (g_dims.rgbButtons[nKey] & 0x80) ? true: false;
}

// }EX̃gK[Ԃ擾
bool GetMouseTrigger(int nKey)
{
	return (g_dimsTrigger[nKey] & 0x80) ? true: false;
}

// }EX̃s[gԂ擾
bool GetMouseRepeat(int nKey)
{
	return (g_dimsRepeat[nKey] & 0x80) ? true: false;
}

// }EX̃|XԂ擾
bool GetMouseRelease(int nKey)
{
	return (g_dimsRelease[nKey] & 0x80) ? true: false;
}

// }EX̍W擾
LONG GetMouseX( void )
{
	return g_dims.lX;
}

// }EX̍W擾
LONG GetMouseY( void )
{
	return g_dims.lY;
}

// }EX̍W擾
LONG GetMouseZ( void )
{

	return g_dims.lZ;

}

// }EXXW̑Έړl
LONG GetMouseDefX( void )
{

	return (long)mouseMove.x;

}

// }EXYW̑Έړl
LONG GetMouseDefY( void )
{

	return (long)mouseMove.y;

}

// }EXZW̐Έړl
LONG GetMouseDefZ( void )
{

	return (long)mouseWheel;

}



